import { Question, Schedule, AppSettings } from '../types';
import { v4 as uuidv4 } from 'uuid';

export const DEFAULT_QUESTIONS: Question[] = [
  {
    id: uuidv4(),
    text: 'How are you feeling right now?',
    category: 'mood',
    active: true,
  },
  {
    id: uuidv4(),
    text: 'How is your energy level?',
    category: 'energy',
    active: true,
  },
  {
    id: uuidv4(),
    text: 'How stressed are you feeling?',
    category: 'stress',
    active: true,
  },
  {
    id: uuidv4(),
    text: 'How well did you sleep last night?',
    category: 'sleep',
    active: true,
  },
  {
    id: uuidv4(),
    text: 'Are you feeling anxious?',
    category: 'anxiety',
    active: true,
  },
  {
    id: uuidv4(),
    text: 'How focused are you?',
    category: 'focus',
    active: true,
  },
];

export const DEFAULT_SCHEDULES: Schedule[] = [
  {
    id: uuidv4(),
    time: '09:00',
    enabled: true,
    days: [1, 2, 3, 4, 5], // Monday - Friday
    randomWindow: 30,
  },
  {
    id: uuidv4(),
    time: '14:00',
    enabled: true,
    days: [1, 2, 3, 4, 5],
    randomWindow: 30,
  },
  {
    id: uuidv4(),
    time: '20:00',
    enabled: true,
    days: [0, 1, 2, 3, 4, 5, 6], // Every day
    randomWindow: 30,
  },
];

export const DEFAULT_SETTINGS: AppSettings = {
  scaleMin: 1,
  scaleMax: 5,
  respectDND: true,
  cloudSyncEnabled: false,
  onboardingComplete: false,
  notificationSound: true,
};

export const SCALE_PRESETS = [
  { label: '1-5', min: 1, max: 5 },
  { label: '1-10', min: 1, max: 10 },
  { label: '0-10', min: 0, max: 10 },
];

export const DAYS_OF_WEEK = [
  { short: 'Sun', long: 'Sunday', value: 0 },
  { short: 'Mon', long: 'Monday', value: 1 },
  { short: 'Tue', long: 'Tuesday', value: 2 },
  { short: 'Wed', long: 'Wednesday', value: 3 },
  { short: 'Thu', long: 'Thursday', value: 4 },
  { short: 'Fri', long: 'Friday', value: 5 },
  { short: 'Sat', long: 'Saturday', value: 6 },
];

export const NOTIFICATION_CHANNEL_ID = 'mood-tracker-prompts';
export const NOTIFICATION_CHANNEL_NAME = 'Mood Check-ins';

export const COLORS = {
  primary: '#6366f1',
  primaryDark: '#4f46e5',
  secondary: '#ec4899',
  background: '#f8fafc',
  surface: '#ffffff',
  text: '#1e293b',
  textSecondary: '#64748b',
  border: '#e2e8f0',
  success: '#22c55e',
  warning: '#f59e0b',
  error: '#ef4444',
  moodLow: '#ef4444',
  moodMedium: '#f59e0b',
  moodHigh: '#22c55e',
};

export const RATING_COLORS: { [key: number]: string } = {
  1: '#ef4444',
  2: '#f97316',
  3: '#f59e0b',
  4: '#84cc16',
  5: '#22c55e',
};

export const getMoodColor = (rating: number, max: number): string => {
  const normalized = rating / max;
  if (normalized <= 0.33) return COLORS.moodLow;
  if (normalized <= 0.66) return COLORS.moodMedium;
  return COLORS.moodHigh;
};
